﻿var importationPreview = {
    context: $("#importPreview"),
    datatable: null,
    previewData: null,
    previewFrom: "",
    taskId: null,
    dataTableColumns: [],
    refreshDataTable: function () {
        importationPreview.datatable.a4datatable("refresh");
    },
    setDataTableColumns: function () {
        $.each(importationPreview.previewData[0], function (name, e) {
            importationPreview.dataTableColumns.push({ "Name": name, "Title": name, "Data": name });
        });
    },
    initializeDataTable: function () {
        importationPreview.datatable = $(".h-importPreviewTable", importationPreview.context).a4datatable({
            serverSide: false,
            data: importationPreview.previewData,
            columns: importationPreview.dataTableColumns
        });
    },
    retreivePreviewData: function () {
        var importWizard = a4.parent().importWizard;
        var importation = a4.parent().importation;
        var previewData = null;

        if (typeof importation !== "undefined" && importationPreview.taskId)
            previewData = importation.previewData || null;

        else if (typeof importWizard !== "undefined")
            previewData = importWizard.previewData || null;

        if (previewData && previewData.ImportationPreview && previewData.ImportationPreview.length > 0) {
            importationPreview.previewData = previewData.ImportationPreview;
            importationPreview.setDataTableColumns();
            importationPreview.initializeDataTable();
        }
        else {
            modalDialog.close();
        }
    }
}

$(document).ready(function () {
    if (importationPreview.context.length > 0) {
        importationPreview.taskId = $("#TaskId", importationPreview.context).val() || null;
        importationPreview.previewFrom = $("#PreviewFrom", importationPreview.context).val();
        importationPreview.retreivePreviewData();
    }
});